<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="robots" content="noindex, nofollow" />
  <title>MahjongBot</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #2c3e50;
      color: #ecf0f1;
      margin: 0;
      padding: 0;
      display: flex;
      flex-direction: column;
      min-height: 100vh;
    }

    .header {
      background-color: #34495e;
      padding: 20px;
      text-align: center;
    }

    .header img {
      width: 200px;
    }

    .container {
      max-width: 900px;
      margin: 0 auto;
      padding: 20px;
      text-align: center;
      padding-bottom: 60px;
      flex-grow: 1;
    }

    .form-container {
      background-color: #34495e;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      margin-bottom: 30px;
      display: inline-block;
      width: 100%;
    }

    .form-container h2 {
      margin-bottom: 20px;
    }

    .form-container input[type="text"] {
      padding: 10px;
      width: 80%;
      margin: 10px 0;
      border-radius: 5px;
      border: 1px solid #ccc;
    }

    .btn {
      padding: 15px 30px;
      background-color: #007bff;
      color: white;
      text-decoration: none;
      border-radius: 5px;
      font-size: 18px;
      margin: 10px 0;
      position: relative;
      overflow: hidden;
    }

    .btn:hover {
      background-color: #16a085;
    }

    .progress-bar {
      position: absolute;
      bottom: 0;
      left: 0;
      width: 100%;
      height: 5px;
      background-color: #ccc;
      border-radius: 5px;
      display: none;
    }

    .progress-bar span {
      display: block;
      height: 100%;
      background-color: #007bff;
      border-radius: 5px;
      width: 0;
    }

    .spinner {
      position: absolute;
      left: 50%;
      top: 50%;
      transform: translate(-50%, -50%);
      width: 24px;
      height: 24px;
      border: 4px solid #f3f3f3;
      border-top: 4px solid #007bff;
      border-radius: 50%;
      animation: spin 2s linear infinite;
    }

    @keyframes spin {
      0% { transform: translate(-50%, -50%) rotate(0deg); }
      100% { transform: translate(-50%, -50%) rotate(360deg); }
    }

    .modal {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-color: rgba(0, 0, 0, 0.5);
      justify-content: center;
      align-items: center;
    }

    .modal-content {
      background-color: #34495e;
      color: #ecf0f1;
      padding: 20px;
      border-radius: 8px;
      width: 70%;
      max-width: 600px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .close {
      color: #aaa;
      float: right;
      font-size: 28px;
      font-weight: bold;
    }

    .close:hover,
    .close:focus {
      color: white;
      text-decoration: none;
      cursor: pointer;
    }

    .footer {
      background-color: #2c3e50;
      color: white;
      padding: 10px;
      text-align: center;
      position: relative;
      margin-top: auto;
    }

    .footer a {
      color: #ecf0f1;
      text-decoration: none;
    }
  </style>
</head>
<body>

  <div class="header">
    <img src="https://dataset58.com/data/logo-tw88.png" alt="MahjongBot Logo">
  </div>

  <div class="container">
    <h2>MahjongBot</h2>

    <div class="form-container">
      <h2>Masukkan Username</h2>
      <form id="formUsername">
        <input type="text" id="username" placeholder="Masukkan Username" required><br>
        <input type="text" id="confirmUsername" placeholder="Konfirmasi Username" required><br>
        <button type="button" class="btn" id="startValidation">Start Verifikasi</button>
      </form>
    </div>
  </div>

  <!-- Modal Popup untuk Proses Bot -->
  <div id="myModal" class="modal">
    <div class="modal-content">
      <span class="close">&times;</span>
      <h2>Bot Mahjong TW88</h2>
      <p><strong>Bot Status:</strong> <span id="botStatus">Tidak aktif</span></p>
      <p><strong>Username:</strong> <span id="displayUsername"></span></p>
      <div id="statusMessage"><strong>Jika Jp Jangan Lupa Sedekah</strong></div>

      <div id="botInformation" style="display: none;">
        <ul id="botRecommendation"></ul>
      </div>

      <button class="btn" id="validateButton" disabled>
        <span id="buttonText">Verifikasi Proses</span>
        <div class="progress-bar" id="progressBar">
          <span id="progressSpan"></span>
        </div>
        <div class="spinner" id="spinner" style="display: none;"></div>
      </button>

      <!-- Tombol Mainkan Sekarang -->
      <a href="https://tw88vip.ink/" class="btn" id="playNowButton" style="display:none;" target="_blank">
        Mainkan Sekarang
      </a>
    </div>
  </div>

  <script>
    const modal = document.getElementById("myModal");
    const closeBtn = document.getElementsByClassName("close")[0];

    document.getElementById("startValidation").addEventListener("click", function() {
      const username = document.getElementById("username").value;
      const confirmUsername = document.getElementById("confirmUsername").value;

      if (username !== confirmUsername) {
        alert("Username tidak cocok!");
        return;
      }

      document.getElementById("displayUsername").innerText = username;
      document.getElementById("startValidation").disabled = true;
      modal.style.display = "flex";

      const progressBar = document.getElementById("progressBar");
      const spinner = document.getElementById("spinner");
      const buttonText = document.getElementById("buttonText");
      progressBar.style.display = "block";
      spinner.style.display = "block";

      buttonText.textContent = "MOHON DITUNGGU";

      const recommendationList = document.getElementById("botRecommendation");
      recommendationList.innerHTML = "";

      // Array mode dan turbo
      const modes = ["manual", "auto"];
      const turbos = ["TURBO ON", "TURBO OFF"];

      // Array angka 5-30 acak
      let times = [];
      for (let i = 0; i < 5; i++) {
        const num = Math.floor(Math.random() * 26) + 5; // 5-30
        const mode = modes[Math.floor(Math.random() * modes.length)];
        const turbo = turbos[Math.floor(Math.random() * turbos.length)];
        times.push(`${turbo} - ${num}x ${mode}`);
      }

      // Menampilkan rekomendasi
      times.forEach((time, index) => {
        setTimeout(() => {
          let li = document.createElement("li");
          li.textContent = time;
          recommendationList.appendChild(li);
        }, index * 2000); // Setiap 2 detik (2000 ms)
      });

      setTimeout(function() {
        document.getElementById("botInformation").style.display = "block";
      }, 3000);

      let progress = 0;
      let progressInterval = setInterval(function() {
        progress += 10;
        document.getElementById("progressSpan").style.width = progress + "%";
        if (progress >= 100) {
          clearInterval(progressInterval);
          document.getElementById("progressSpan").style.width = "100%";
          document.getElementById("statusMessage").innerText = "Verifikasi selesai! Gaskan Coeg!!";
          
          // Ubah tombol menjadi "Mainkan Sekarang"
          document.getElementById("validateButton").style.display = "none";
          const playNowButton = document.getElementById("playNowButton");
          playNowButton.style.display = "inline-block";
          playNowButton.href = "https://tw88vip.ink/";

          // Hapus spinner dan progress bar
          document.getElementById("spinner").style.display = "none";
          document.getElementById("progressBar").style.display = "none";
        }
      }, 1000);
    });

    closeBtn.addEventListener("click", function() {
      modal.style.display = "none";
      window.location.href = "/aplikasi/";
    });

    window.onclick = function(event) {
      if (event.target == modal) {
        modal.style.display = "none";
        window.location.href = "/aplikasi/";
      }
    };
  </script>
</body>
</html>
